/*********************************************************************
*	created:	2007/4/12
*	pathname:	Source\prj\Lib\CMDS\IcadEdJig.h
*	author:		 Ƴ
*	
*	purpose:	class IcadEdJig header file
*********************************************************************/

#ifndef ICAD_EDIT_JIG__H
#define ICAD_EDIT_JIG__H

///////////////////////////////////////////////////////////////////////
// Ͷ壬Ժȥ
typedef char IcChar;
typedef const IcChar* PCIcChar;

//typedef double sds_point[3];
//typedef long sds_name[2];
//struct sds_resbuf;

typedef sds_point IcPoint3d;

///////////////////////////////////////////////////////////////////////
//
#pragma pack (push, 8)

class  IcSelset;
class  IcEdImpJig;
class  IcEntityContainer;

/** class IcObjectId
  Wrap up sds_name of Selection Set which contains new "Append" Entities.
  And the SelSet sds_name will AUTO FREE.

  // װѡ: ´һʵӵ IcObjectId ѡ
  // Ŀ: ACADݣͬʱͻ½ʵ
  // ע: Զͷѡ, ΪȨ IcObjectId 
 */
class IcObjectId
{
	friend class IcEdJig;
	friend class IcEdImpJig;
public:
	IcObjectId();
	IcObjectId(const IcObjectId&);
	~IcObjectId();

	IcObjectId& operator= (const IcObjectId&);

	int getEntname(int idx, sds_name ent) const;
	size_t getSize() const;

private:
	IcSelset *m_pSS;
	void attach(IcSelset*);
	void detach();
};

/** class IcEntityPtr
  Wrap up sds_resbuf list, which will be drawn while draging and will append to DataBase if succeed.
  WARNING: Application MUST FREE sds_resbuf.

  // װ sds_resbuf: ϶ʾʵͬʱͨ append(), ʵӵļ.
  // Ŀ: ACADݣͬʱʵ϶Ч
  // ˵: ͻ»ʱõ clear() ʵȻۻ.
  // ע: ͻͷsds_resbufڴ, ΪǵȨڿͻ.
 */
class IcEntityPtr
{
	friend class IcEdJig;
	friend class IcEdImpJig;
public:
	IcEntityPtr();
	IcEntityPtr(const IcEntityPtr&);
	~IcEntityPtr();

	IcEntityPtr& operator= (const IcEntityPtr&);

	bool add(const sds_resbuf* pResbuf);

	void clear();

	size_t size() const;

private:
	IcEntityContainer *m_pEntityContainer;
	void attach(IcEntityContainer*);
	void detach();
};


/**
    class IcEdJig, ICAD Edit Jig Base class.
	// Ͳ˵.
 */
class IcEdJig 
{
public:
    //ACRX_DECLARE_MEMBERS(AcEdJig);

	/************************************************************************/
	/*                         Enumerations                                 */
	/************************************************************************/
	/**
		enum UserInputControls
	 */
	typedef enum UserInputControls {
		kGovernedByOrthoMode         = 0x0001,
		kNullResponseAccepted        = 0x0002,
		kDontEchoCancelForCtrlC      = 0x0004,
		kDontUpdateLastPoint         = 0x0008,
		kNoDwgLimitsChecking         = 0x0010,
		kNoZeroResponseAccepted      = 0x0020,
		kNoNegativeResponseAccepted  = 0x0040,
		kAccept3dCoordinates         = 0x0080,
		kAcceptMouseUpAsPoint        = 0x0100,
		kAnyBlankTerminatesInput     = 0x0200,
		kInitialBlankTerminatesInput = 0x0400,
		kAcceptOtherInputString      = 0x0800,
		kGovernedByUCSDetect         = 0x1000,
		kNoZDirectionOrtho           = 0x2000
    };

	/**
		enum DragStatus
	 */
	typedef enum DragStatus {
        kModeless       = -17,
        kNoChange       = -6,
        kCancel         = -4,
        kOther          = -3,
        kNull           = -1,
        kNormal         = 0,
        kKW1,
        kKW2,
        kKW3,
        kKW4,
        kKW5,
        kKW6,
        kKW7,
        kKW8,
        kKW9
    };

	/**
		enum CursorType
	 */
	typedef enum CursorType {
        kNoSpecialCursor = -1,           // No Special Cursor Specified
        kCrosshair = 0,                  // Full Screen Cross Hair. 
        kRectCursor,                     // Rectangular cursor. 
        kRubberBand,                     // Rubber band line. 
        kNotRotated,                     // NotRotated Type. 
        kTargetBox,                      // Target Box Type. 
        kRotatedCrosshair,               // Rotated Crosshair w/ rubber band. 
        kCrosshairNoRotate,              // Crosshairs forced non-rotated. 
        kInvisible,                      // Invisible cursor. 
        kEntitySelect,                   // Entity selection target cursor. 
        kParallelogram,                  // Parallelogram cursor. 
        kEntitySelectNoPersp,            // Pickbox, suppressed in persp. 
        kPkfirstOrGrips,                 // Auto-select cursor. 
        kCrosshairDashed                 // 15 dashed style crosshair cursor
    };

	/************************************************************************/
	/*                  Constructors & Destructors                          */
	/************************************************************************/
	/**
		CTor & DTor
	 */
	IcEdJig();
	virtual ~IcEdJig();

	/************************************************************************/
	/*                          Processing                                  */
	/************************************************************************/

	/** 
	  drag(): (Processing), ûԵ, 
	  ˵Jig ڲק
	  أDragStatus - ק״̬
	 */
    DragStatus drag();

	/** 
	  append(): (Processing), ûԵ, 
	  ˵קɹ, û԰ʵӵݿ
	  أIcObjectId - ɹ m_ename[1] != NULL; ʧ m_ename[1] == NULL
	  עͣ
        In the jig operation, Calls the entity() function to get IcEntityPtr of the entities, 
        appends these entities to default space (that is, *Model or *Paper) of the current database, draws them, 
        and returns their IcObjectId(Selection Set). Once appended to the database, the object's memory is
        the responsibility of the database and must not be deleted by the application.
        But IcObjectId which is SelSet, MUST FREE in the application. By default, DTor of IcObjectId will free it.
	 */
    IcObjectId append();
	
	/************************************************************************/
	/*                         Setup & Query                                */
	/************************************************************************/

	/** 
	  setKeywordList(): ú(Setup), ûɵ, 
	  ˵ؼб
	  PCIcChar pKeyWord - ؼбַָ
	  עͣ
        Uses a copy of keywordList as the keyword list for subsequent acquireXxxx() functions calls. 
        The keyword list can contain up to 30 keywords. The list form is a follows:
          The keyword list is a space delimited list of the form "Key1 KEy2 KEY3,ABBREV3". 
          Abbreviations are optional, and two methods of specifying them are supported. 
          1. The required portion can be upper case and the rest lower case, 
             or the required portion can be repeated, separated from the keyword by a comma. 
          2. The second method is intended to facilitate translation to foreign languages that may have difficulty 
		     with case conversion. 
          In either method, the length of the required portion is simply used as the minimum length 
		  that must match exactly. (For the comma-delimited method, it is assumed that the abbreviation string 
		  is a proper subset of the keyword start.)
	 */
    void setKeywordList(PCIcChar pKeyWord);

    /**
	  keywordList(): ѯ(Query), ûɵ, 
	  ˵ȡ setKeywordList() õؼб, ޣΪַ
	  أPCIcChar - ؼбַָ
	  עͣο
        This is not a pointer to a string copy, so do not make any attempts to delete the string pointed.
     */
    PCIcChar keywordList();

    /**
	  setDispPrompt(): ú(Setup), ûɵ, 
	  ˵ʾ
	  PCIcChar pPrompt - µʾַ, ֧ printf() ʽ
	        ... - printf()ʽѡĲ(optional printf() style formatting codes)
	  עͣ
        Uses a copy of dispPrompt as the new prompt string for subsequent drag operations. 
	    The dispPrompt string may contain standard printf() style formatting codes with 
		additional arguments following dispPrompt, one for each formatting code, 
		in the same way that printf() and sds_printf() work.
	    This function should be called just before calling the drag() method that uses the prompt being set.
	 */
    void setDispPrompt(PCIcChar pPrompt, ...);

    /**
	  dispPrompt(): ѯ(Query), ûɵ, 
	  ˵ȡ setDispPrompt() õġʽʾַ, ޣΪַ
	  أPCIcChar - ʾַָ
	  עͣο
        This is not a pointer to a string copy, so do not make any attempts to delete the string pointed.
	 */
    PCIcChar dispPrompt();

    /**
	  setSpecialCursorType(): ú(Setup), ûɵ, 
	  ˵ضĹ
	  CursorType ctype - µĹ
	 */
    void setSpecialCursorType(CursorType ctype);

    /**
	  specialCursorType(): ѯ(Query), ûɵ, 
	  ˵ȡ setSpecialCursorType() õĹ, ޣΪ kNoSpecialCursor
	  أCursorType - 
	 */
    CursorType specialCursorType();

    /**
	  setUserInputControls(): ú(Setup), ûɵ, 
	  ˵ûƷʽ
	  UserInputControls uic - Ʒʽ
	  עͣ
	    Sets the user input control attributes for the next call to acquireXxxx() to uic.
	    The value of uic can be a single, or multiple UserInputControls together. 
	 */
	void setUserInputControls(UserInputControls uic);

    /**
	  userInputControls(): ѯ(Query), ûɵ, 
	  ˵ȡûƷʽֵ
	  أUserInputControls - Ʒʽ
	  עͣο
	 */
    UserInputControls userInputControls();

	/************************************************************************/
	/*                          User Input                                  */
	/************************************************************************/

    /**
	  acquireXXX(): û뺯(User Input), ûɵ,   
	  أǰק״̬
	 */
    /** acquireString() 
	  IcChar *str - ַָ
	        size_t size - ַС
	  ע⣺ACADݣ
	 */
    DragStatus acquireString(IcChar *str, size_t size);

    /** acquireAngle() 
	  double &ang - Ƕȣ(0,0,0) Ϊ
	 */
    DragStatus acquireAngle(double &ang);
    /** acquireAngle() 
	  double &ang - Ƕȣڻ basePnt
	        const IcPoint3d& basePnt - 
	 */
    DragStatus acquireAngle(double &ang, const IcPoint3d& basePnt);

    /** acquireDist() 
	  double &dist - 룬(0,0,0) Ϊ
	 */
    DragStatus acquireDist(double &dist);
    /** acquireDist() 
	  double &dist - 룬ڻ basePnt
	        const IcPoint3d& basePnt - 
	 */
    DragStatus acquireDist(double &dist, const IcPoint3d& basePnt);

    /** acquirePoint() 
	  IcPoint3d& pnt - λõ㣬(0,0,0) Ϊ
	 */
    DragStatus acquirePoint(IcPoint3d& pnt);
    /** acquirePoint() 
	  IcPoint3d& pnt - λõ㣬ڻ basePnt
	        const IcPoint3d& basePnt - 
	 */
    DragStatus acquirePoint(IcPoint3d& pnt, const IcPoint3d& basePnt);

	/************************************************************************/
	/*                       *Overridden*                                   */
	/************************************************************************/

	/**
	  entity(): غ(Overridden), û, 
	  ˵ȡק IcEntityPtr 
	  أIcEntityPtr - ק IcEntityPtr , ǿռʱſԲק.
	  עͣ
        This function is required to be overridden to return a IcEntityPtr object.
        The same object throughout the course of an drag() call. 
        It is the entities that drag() drags, and that update() updates.
        Application's command normally creates new instance of the acquiring entities 
        which wish to drag, are stored in IcEntityPtr, and partially initialize it 
		prior to using drag(), update(), or append().
	 */
    virtual IcEntityPtr entity() const;

    /**
	  sampler(): غ(Overridden), û, 
	  ˵ȡICAD ϵͳãͻҪ֪ͨͨ ICAD ϵͳǷҪ
	  أDragStatus - ǰק״̬, Ϊ kNoChange,  ICAD ϵͳ IcEntityPtr .
	  עͣ
        This overridden function is called within drag() to solicit entity-defining input from the user. 
        Before sampler() is called, ICAD's input system is primed to accept "tentative" input.
		If sampler() gets usable input, it must make it available for update() to define the state of IcEntityPtr. 
        It should NOT modify the entities, as it may be called at any time during entity elaboration, 
        and such modification could confuse the elaboration code.
	 */
	virtual DragStatus sampler(); 

	/**
	  update(): غ(Overridden), û, 
	  ˵´ICAD ϵͳ֪ͨͨͻ IcEntityPtr 
	  أbool - Ƿ³ɹ, ICAD ϵͳⷵ״̬ɹػק.
	  עͣ
	  This overridden function is called subsequent to a successful call to sampler() and 
	  before the dragger starts an elaboration of the IcEntityPtr. It may also be called by 
	  the client at will. It has the job of applying sampler()'s input to the acquiring entities.
	  It can fail, meaning that the sampler input doesn't define a valid IcEntityPtr. 
	  It signifies this by returning 'false', or should return 'true' if successfully completes.
	 */
	virtual bool update();

	/**
	  עأ֧
	  */
	//virtual IcDbDimDataPtrArray* dimData(const double dimScale);
	//virtual ErrorStatus setDimValue(const AcDbDimData* dimData, const double dimValue); 

private:
	/**
	  ڲʹñJig ʵָ
	  */
	IcEdImpJig*  m_pImpJig;
};


#pragma pack (pop)
//
///////////////////////////////////////////////////////////////////////


#endif //ICAD_EDIT_JIG__H

